Attribute VB_Name = "PrintModule"
Option Explicit

Dim curX
Dim curY
Dim curPicture
Dim curFile

' certs sheet printer control file
' <>                        comment line
' <PRINT> text              print text at current location
' <EOF>                     end of file
' <GOTO> x y                goto position xy on printer page
' <FONTNAME> name           set new font name
' <FONTSIZE> n              set new font size
' <FONTSTYLE>
'   bold                    strings used in FONTSTYLE
'   bold off
'   italic
'   italic off
'   underline
'   underline off
' <PICTURE> filename        put picture at current location
' <LINE> x y                draw line from current xy to xy in line command
' <RGOTO> rx ry             Relative goto, currentx+rx currenty+ry
' <REVERSEPRINT> text       light text on dark backround
' <CR>                      new line

Public Sub CertsPrint()
Dim FileNumber
Dim fileRecord
Dim fileEOF As Boolean  ' end of file
Dim fileEOR As Boolean  ' end of record
Dim printCmnd
Dim printField
Dim fieldLength
Dim recordPos
Dim temp
Dim tempX, tempY
Dim printX, printY

On Error GoTo CertsError

printX = 0  ' relative positions
printY = 0
    
    FileNumber = FreeFile   ' Get unused file
    Open "c:\program files\smarttrak\Certs.Txt" For Input As #FileNumber
    fileEOF = False
    
    While fileEOF = False
        
        fileEOR = False
        Line Input #FileNumber, fileRecord
        
        While fileEOR = False
            recordPos = InStr(1, fileRecord, "<")
            If recordPos = 0 Then
                fileEOR = True
            Else
                recordPos = InStr(1, fileRecord, ">")
                If recordPos = 0 Then
                    fileEOR = True
                Else
                    printCmnd = Left(fileRecord, recordPos)
                    fieldLength = InStr(recordPos, fileRecord, "<")
                    If fieldLength = 0 Then
                        fileEOR = True
                        printField = Mid(fileRecord, recordPos + 1)
                    Else
                        printField = Mid(fileRecord, recordPos + 1, fieldLength - (recordPos + 1))
                        fileRecord = Mid(fileRecord, fieldLength)   ' move to next command
                    End If
                    Select Case printCmnd
                    Case "<>"
                        fileEOR = True ' only item allowed on a line is comments
                    Case "<PRINT>"
                        Printer.Print printField;
                    Case "<GOTO>"       ' x y numbers
                        printField = Trim(printField)
                        temp = Split(printField, " ")
                        Printer.CurrentX = temp(0) + printX
                        Printer.CurrentY = temp(1) + printY
                    Case "<RGOTO>"
                        printField = Trim(printField)
                        temp = Split(printField)
                        printX = temp(0)
                        printY = temp(1)
                    Case "<LINE>"
                        printField = Trim(printField)
                        temp = Split(printField)
                        Printer.Line (Printer.CurrentX, Printer.CurrentY)-(temp(0), temp(1))
                    Case "<CR>"
                        Printer.Print
                        Printer.CurrentX = Printer.CurrentX + printX
                    Case "<FONTNAME>"
                        Printer.Font = printField
                    Case "<FONTSIZE>"
                        Printer.FontSize = printField
                    Case "<FONTSTYLE>"
                        Select Case printField
                        Case "bold"
                            Printer.FontBold = True
                        Case "bold off"
                            Printer.FontBold = False
                        Case "italic"
                            Printer.FontItalic = True
                        Case "italic off"
                            Printer.FontItalic = False
                        Case "underline"
                            Printer.FontUnderline = True
                        Case "underline off"
                            Printer.FontUnderline = False
                        End Select
                    Case "<REVERSEPRINT>"   ' needs work if needed
 '                       tempX = Printer.CurrentX
 '                       tempY = Printer.CurrentY
 '                       Printer.ForeColor = vbWhite
 '                       Printer.Print printField;
 '                       Printer.Line (tempX, tempY)- _
 '                       (tempX + Printer.TextWidth(printField), tempY + Printer.TextHeight(printField)), _
 '                       vbBlack, BF
 '                       Printer.ForeColor = vbBlack
                    Case "<EOF>"
                        fileEOF = True  ' last command
                        fileEOR = True
                    End Select
                End If
            End If
        Wend
    Wend
   


CertsError:

    Close #FileNumber
    Printer.EndDoc
'    printer.KillDoc

End Sub
